/*  Setze für einen gegebenen AG die noch notwendige Arbeitszeitzeit zurück.

    Lösche dabei alte Blockierungen des Überhangs und entferne vorher gesetzte conflicted-Status.
*/
SELECT tsystem.function__drop_by_regex( 'ab2__required_worktime__reset', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__required_worktime__reset(
    _ab2_id         int
) RETURNS bool AS $$
DECLARE
    _row_count   int;
    _ab2_record record;
BEGIN

  UPDATE ab2_wkstplan
     SET a2w_stukorr = null
   WHERE a2w_a2_id   = _ab2_id;

  GET DIAGNOSTICS _row_count = ROW_COUNT;

  IF ( _row_count = 0 ) THEN
      RAISE EXCEPTION 'illegal ab2_id: %', _ab2_id;
  END IF;

  -- Daten des AG holen.
  SELECT a2_id, a2_ab_ix, a2_n, min(ti_date_start) as min_ti_date_start, max(ti_date_end) as max_ti_date_end, ti_resource_id
  INTO _ab2_record
  FROM ab2
  LEFT JOIN scheduling.resource_timeline ON a2_id = ti_a2_id
  WHERE a2_id = _ab2_id
  GROUP BY a2_id, a2_ab_ix, a2_n, ti_resource_id;

  -- Vorher gesetzte Blockierungen entfernen.
  DELETE FROM scheduling.resource_timeline
  WHERE
        ti_type = 'task.blocktime'
    AND ti_a2_id = _ab2_record.a2_id
  ;

  -- Vorher gesetzte conflicted-Status entfernen.
  UPDATE scheduling.resource_timeline
  SET ti_stat = null
  WHERE
            ti_stat = 'conflicted'
        AND ti_type IN ( 'task', 'task.buffer' )
        AND ti_a2_id IN (SELECT a2_id FROM ab2 WHERE a2_ab_ix =_ab2_record.a2_ab_ix);

  RETURN true;

END $$ language plpgsql;
